#include <iostream>
#include <vector>
#include <cmath>
#include <limits>
#include <array> 
#include <utility>
#include <algorithm>
#include <numeric>

using namespace std;

int main() {
    int n;
    cin >> n;

    vector<pair<int, int>> ps(n);
    for (int i = 0; i < n; ++i) {
        cin >> ps[i].first >> ps[i].second;
    }

    long double mdist = -1.0;
    pair<array<long double, 3>, array<long double, 3>> best;

    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            if (i == j) continue;

            long double dx = ps[j].first - ps[i].first, dy = ps[j].second - ps[i].second;
            long double a = dx, b = dy;

            long double mi = numeric_limits<long double>::infinity();
            long double ma = -numeric_limits<long double>::infinity();
            for (pair<int, int>& p : ps) {
                long double v = a * p.first + b * p.second;
                if (v < mi) mi = v;
                if (v > ma) ma = v;
            }

            long double dist = (a != 0 || b != 0) ? (ma - mi) / sqrt(a * a + b * b) : 0.0;

            if (dist > mdist) {
                mdist = dist;
                long double c1 = -ma;
                long double c2 = -mi;
                if (c1 > c2) swap(c1, c2);
                if(abs(c1) == 0) c1 = 0;
                if(abs(c2) == 0) c2 = 0;
                best = { {a, b, c1}, {a, b, c2} };
            }
        }
    }

    cout << best.first[0] << " " << best.first[1] << " " << best.first[2] << "\n";
    cout << best.second[0] << " " << best.second[1] << " " << best.second[2] << "\n";

    return 0;
}
