#include <iostream>
#include <vector>
#include <cmath>
#include <limits>
#include <array> 
#include <utility>
#include <algorithm>
#include <numeric>

using namespace std;

int main() {
    int n;
    cin >> n;

    vector<pair<int, int>> ps(n);
    for (int i = 0; i < n; ++i) {
        cin >> ps[i].first >> ps[i].second;
    }

    long long mdist = -1.0;
    pair<array<long long, 3>, array<long long, 3>> best;

    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            if (i == j) continue;

            long long dx = ps[j].first - ps[i].first, dy = ps[j].second - ps[i].second;
            long long a = dx, b = dy;

            long long mi = numeric_limits<long long>::infinity();
            long long ma = -numeric_limits<long long>::infinity();
            for (pair<int, int>& p : ps) {
                long long v = a * p.first + b * p.second;
                if (v < mi) mi = v;
                if (v > ma) ma = v;
            }

            long long dist = (a != 0 || b != 0) ? (ma - mi) / sqrt(a * a + b * b) : 0.0;

            if (dist > mdist) {
                mdist = dist;
                long long c1 = -ma;
                long long c2 = -mi;
                if (c1 > c2) swap(c1, c2);
                best = { {a, b, c1}, {a, b, c2} };
            }
        }
    }

    cout << best.first[0] << " " << best.first[1] << " " << best.first[2] << "\n";
    cout << best.second[0] << " " << best.second[1] << " " << best.second[2] << "\n";

    return 0;
}
