#include <iostream>
#include <vector>
#include <cmath>

using namespace std;
using ll = long long;

struct line{
    double A, B, C;
};
struct point{
    double x, y;
};
line perp(const line& l, const pair<ll, ll> & p){
    return line{-l.B, l.A, l.B * p.first - l.A * p.second};
};
line linefrompp( pair<ll, ll>& p1,  pair<ll, ll>& p2) {
    double A = p2.second - p1.second;
    double B = p1.first - p2.first;
    double C = p2.first * p1.second - p1.first * p2.second;
    return {A, B, C};
}

int main(){

    int n;
    cin >> n;

    vector <pair<ll,ll>> v(n);
    for (int i = 0; i < n; i++){
        int tmp1, tmp2;
        cin >> tmp1 >> tmp2;
        v[i] = {tmp1, tmp2};
    }

    double max_dist = -1;
    pair <ll, ll> p1 = {0, 0}, p2 = {0, 0};

    for (int i = 0; i < n - 1; i++){
        for (int j = i + 1; j < n; j++){
            double dist = sqrt(pow((v[i].first - v[j].first), 2) + pow(v[i].second - v[j].second, 2));
            if (dist > max_dist){
                max_dist = dist;
                p1 = {v[i].first, v[i].second};
                p2 = {v[j].first, v[j].second};
            }
        }
    }

    line l = linefrompp(p1, p2);

    line l1 = perp(l, p1);
    line l2 = perp(l, p2);

    cout << (long long) l1.A << ' ' << (long long) l1.B << ' ' << (long long) l1.C << endl;
    cout << (long long) l2.A << ' ' << (long long) l2.B << ' ' << (long long) l2.C << endl;

    return 0;
}