import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.*;

public class Main {
    static class FastReader {
        BufferedReader br;
        StringTokenizer st;
        FastReader() {
            br = new BufferedReader(new InputStreamReader(System.in));
        }
        String next() {
            try {
                while(st == null || !st.hasMoreElements()) {
                    st = new StringTokenizer(br.readLine());
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            return st.nextToken();
        }
        Integer nextInt() {
            return Integer.parseInt(next());
        }
        Long nextLong() {
            return Long.parseLong(next());
        }
        String nextLine() {
            String str = "";
            try {
                str = br.readLine();
            } catch(IOException e) {
                e.printStackTrace();
            }
            return str;
        }
    }
    static FastReader scan = new FastReader();
    static double dis(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }
    public static void main(String[] args) {
        int[][] p = new int[4][2];
        for(int i = 0; i < 4; i++) {
            for(int j = 0; j < 2; j++) p[i][j] = scan.nextInt();
        }
        List<Double> distances = new ArrayList<>();
        for(int i = 1; i < 4; i++) {
            double x = dis(p[0][0], p[0][1], p[i][0], p[i][1]);
            distances.add(x);
        }
        Collections.sort(distances);
        double r1 = distances.get(0) / 2;
        double r2 = distances.get(1) / 2;
//        System.out.println(r1 + " " + r2);
        System.out.println(Math.PI * r1 * r2);
    }

}