#include <iostream>
#include <vector>
#include <cmath>
#include <array>
#include <algorithm>
#include <unordered_set>
#include <map>
#include <unordered_map>
#include <string>
using namespace std;

void reorder(short& a, short& b, short& c) {
    if (a > b) {
        const short tmp = a;
        a = b;
        b = tmp;
    }
    if (b > c) {
        const short tmp = b;
        b = c;
        c = tmp;
        if (a > b) {
            const short tmp2 = a;
            a = b;
            b = tmp2;
        }
    }
}

string repeat(char c, int count) {
    string r;
    while (count-- > 0) {
        r += c;
    }
    return r;
}

void print1(short a, short b, short c, short d) {
    cout << 'z' << repeat('a', c - d) << '\n';
}
void print2(short a, short b, short c, short d) {
    cout << 'z' << repeat('b', c) << '\n';
}
void print3(short a, short b, short c, short d) {
    cout << 'z' << repeat('b', c - b) << repeat('c', d) << repeat('a', b - 3 * (d >> 1)) << '\n';
}

void print_1(short a, short b, short c, short d) {
    cout << 'z' << repeat('a', c - d) << '\n';
}
void print_2(short a, short b, short c, short d) {
    cout << 'z' << repeat('b', c) << '\n';
}
void print_3(short a, short b, short c, short d) {
    cout << 'z' << repeat('b', c - b) << repeat('c', d - 1) << repeat('a', b - 3 * (d >> 1)) << '\n';
}

typedef void (*print_f)(short, short, short, short);

array<array<print_f, 3>, 6> print_order{
    array{print1, print2, print3},
    array{print1, print3, print2},
    array{print2, print1, print3},
    array{print2, print3, print1},
    array{print3, print1, print2},
    array{print3, print2, print1}
};

array<array<print_f, 3>, 6> print_order_{
    array{print_1, print_2, print_3},
    array{print_1, print_3, print_2},
    array{print_2, print_1, print_3},
    array{print_2, print_3, print_1},
    array{print_3, print_1, print_2},
    array{print_3, print_2, print_1}
};

int main() {
    short a, b, c, a0, b0, c0;
    cin >> a >> b >> c;
    a0 = a;
    b0 = b;
    c0 = c;

    reorder(a, b, c);

    if ( a + b < c) {
        cout << "No" << endl;
        return 0;
    }

    short d = (a + b - c + 1) & ((1 << 14) - 2);

    cout << "Yes\n";

    int order;

    if (a0 <= b0) {
        if (b0 <= c0) order = 4;
        else if (a0 <= c0) order = 1;
        else order = 3;
    } else {
        if (a0 <= c0) order = 5;
        else if (b0 <= c0) order = 0;
        else order = 2;
    }

    if ((a + b - c) & 1) {
        for (auto f : print_order_[order]) {
            f(a, b, c, d);
        }
    } else {
        for (auto f : print_order[order]) {
            f(a, b, c, d);
        }
    }

    cout.flush();

    return 0;
}
